% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitMarginals.R
\name{marginalNLS}
\alias{marginalNLS}
\title{Fit two 4-parameter log-logistic functions with non-linear least squares}
\usage{
marginalNLS(data, transforms = NULL, start, model, nlsfn = nls, ...)
}
\arguments{
\item{data}{Dose-response dataframe. Marginal data will be extracted from
it automatically.}

\item{transforms}{Transformation functions. If non-null, \code{transforms} is
a list containing 5 elements, namely biological and power transformations
along with their inverse functions and \code{compositeArgs} which is a list
with argument values shared across the 4 functions. See vignette for more
information.}

\item{start}{Starting parameter values. If not specified, they will be
obtained from \code{\link{initialMarginal}}.}

\item{model}{List with model parameters. Typically, this is an output from
\code{\link{constructFormula}}.}

\item{nlsfn}{Non-linear least-squares optimizer function}

\item{...}{Further arguments that are not used at present}
}
\description{
This function does not automatically extract marginal data and requires
model input obtained from \code{\link{constructFormula}}.
}
