% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_phylogeny_complete}
\alias{BIEN_phylogeny_complete}
\title{Download the complete BIEN phylogenies}
\usage{
BIEN_phylogeny_complete(n_phylogenies = 1, seed = NULL, replicates = NULL,
  ...)
}
\arguments{
\item{n_phylogenies}{The number of phylogenies to download.  Should be an integer between 1 and 100.  Default is 1.}

\item{seed}{Argument passed to set.seed.  Useful for replicating work with random phylogeny sets.}

\item{replicates}{The specific replicated phylogenies to return.  Should be a numeric vector of integers between 1 and 100.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A phylo or multiphylo object containing the specified phylogenies
}
\description{
BIEN_phylogeny_complete downloads a specified number of the BIEN phylogeny replicates.
}
\note{
Information on the construction of the BIEN phylogenies is available online at http://bien.nceas.ucsb.edu/bien/biendata/bien-2/phylogeny/
}
\examples{
\dontrun{
phylos<-BIEN_phylogeny_complete(n_phylogenies = 10,seed = 1)
phylos<-BIEN_phylogeny_complete(replicates = c(1,2,99,100))}
}
\seealso{
Other phylogeny functions: \code{\link{BIEN_phylogeny_conservative}}
}
