% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildComponent.R
\name{ped2mit}
\alias{ped2mit}
\alias{ped2mt}
\title{Take a pedigree and turn it into a mitochondrial relatedness matrix}
\usage{
ped2mit(
  ped,
  max.gen = 25,
  sparse = TRUE,
  verbose = FALSE,
  gc = FALSE,
  flatten.diag = FALSE,
  standardize.colnames = TRUE,
  transpose_method = "tcrossprod",
  adjacency_method = "direct",
  saveable = FALSE,
  resume = FALSE,
  save_rate = 5,
  save_rate_gen = save_rate,
  save_rate_parlist = 1e+05 * save_rate,
  save_path = "checkpoint/",
  ...
)
}
\arguments{
\item{ped}{a pedigree dataset.  Needs ID, momID, and dadID columns}

\item{max.gen}{the maximum number of generations to compute
(e.g., only up to 4th degree relatives).  The default is 25. However it can be set to infinity.
 `Inf` uses as many generations as there are in the data.}

\item{sparse}{logical.  If TRUE, use and return sparse matrices from Matrix package}

\item{verbose}{logical.  If TRUE, print progress through stages of algorithm}

\item{gc}{logical. If TRUE, do frequent garbage collection via \code{\link{gc}} to save memory}

\item{flatten.diag}{logical. If TRUE, overwrite the diagonal of the final relatedness matrix with ones}

\item{standardize.colnames}{logical. If TRUE, standardize the column names of the pedigree dataset}

\item{transpose_method}{character. The method to use for computing the transpose.  Options are "tcrossprod", "crossprod", or "star"}

\item{adjacency_method}{character. The method to use for computing the adjacency matrix.  Options are "loop", "indexed", direct or beta}

\item{saveable}{logical. If TRUE, save the intermediate results to disk}

\item{resume}{logical. If TRUE, resume from a checkpoint}

\item{save_rate}{numeric. The rate at which to save the intermediate results}

\item{save_rate_gen}{numeric. The rate at which to save the intermediate results by generation. If NULL, defaults to save_rate}

\item{save_rate_parlist}{numeric. The rate at which to save the intermediate results by parent list. If NULL, defaults to save_rate*1000}

\item{save_path}{character. The path to save the checkpoint files}

\item{...}{additional arguments to be passed to \code{\link{ped2com}}}
}
\description{
Take a pedigree and turn it into a mitochondrial relatedness matrix
}
\details{
The algorithms and methodologies used in this function are further discussed and exemplified in the vignette titled "examplePedigreeFunctions". For more advanced scenarios and detailed explanations, consult this vignette.
}
