% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{excel_to_list}
\alias{excel_to_list}
\title{Read Data from Excel}
\usage{
excel_to_list(file, first_column_as_time=TRUE, skipsheet=NULL, ...)
}
\arguments{
\item{file}{A path to the file.}

\item{first_column_as_time}{Logical indicating whether the first column indicates the time.}

\item{skipsheet}{If one or more sheets should be skipped for reading, this can be provided with this argument. Either a vector of numeric indices or a vector of strings.}

\item{...}{Additional arguments.}
}
\value{
Returns a list of length \code{N} which contains each a matrix of size T times k, where T are time periods and k variables per entity.
}
\description{
Reads a spreadsheet from excel and converts it to a list for use of \code{bgvar}.
}
\details{
Note that each sheet has to be named for a respective country. Column names are used as variable names. Reader uses the \code{readxl} R package, hence additional arguments can be passed to the function. Furthermore, if \code{first_column_as_time=TRUE} then the column name has also to be time.
}
\seealso{
\code{\link{bgvar}}
}
\author{
Maximilian Boeck
}
