% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgvar_main.R
\name{fitted.bgvar}
\alias{fitted.bgvar}
\title{Extract Model Fitted Values}
\usage{
\method{fitted}{bgvar}(object, ..., global = TRUE)
}
\arguments{
\item{object}{an object of class \code{bgvar}.}

\item{...}{additional arguments.}

\item{global}{if \code{TRUE} global fitted values are returned otherwise country fitted values.}
}
\value{
Returns an \code{T} times \code{K} matrix, where \code{T} is the number of observations and \code{K} number of endogenous variables.
}
\description{
Extracts the fitted values for \code{bgvar}.
}
\examples{
\donttest{
library(BGVAR)
data(eerData)
model.ng <- bgvar(Data=eerData,W=W.trade0012,plag=1,saves=100,burns=100)
fitted(model.ng)
}
}
