% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CuPloth.R
\name{CuPloth}
\alias{CuPloth}
\title{Plots for the Hazard and Survival Funcion Estimates}
\usage{
CuPloth(M, type.h = "segment", confidence = 0.95, qn = 0.5,
  summary = FALSE, position_label = "right")
}
\arguments{
\item{M}{tibble. Contains the output generated by \code{CuMRres}.}

\item{type.h}{character. "segment"= use segments to plot hazard rates,
"line" = link hazard rates by a line}

\item{confidence}{Numeric. Confidence level.}

\item{qn}{Numeric. Quantile for Tao that should be visualized on the plot.}

\item{summary}{Logical. If \code{TRUE}, a summary for hazard and survival
functions is returned as a tibble.}

\item{position_label}{character. Labels on the right or left side of the
plot.}
}
\value{
\item{SUM.h}{Numeric tibble. Summary for the mean, median, and a
\code{confint / 100} confidence interval for each segment of the hazard
function. If \code{summary = TRUE}} \item{SUM.S}{Numeric tibble. Summary for
the mean, median, and a \code{confint / 100} confidence interval for a grid of 
the survival function. If \code{summary = TRUE}}
}
\description{
Plots the hazard function and the survival function
estimates defined by the bayesian semiparametric cure 
rate model with an unknown threshold
(Nieto-Barajas & Yin, 2008).
}
\details{
This function return estimators plots for the resulting hazard rate as it is computed
by \link{CuMRes} and the cure time (quantile of Tao specified by the user), 
together with credible intervals. Additionally, it plots the survival function and the cure proportion estimates
with their corresponding credible intervals.
}
\examples{



## Simulations may be time intensive. Be patient.

## Example 1
# data(crm3)
    # times<-crm3$times
    # delta<-crm3$delta
    # res <- CuMRes(times, delta, type.t = 2, length = .1,
    #                   K = 100, alpha = rep(1, 100  ),
    #                   beta = rep(1, 100),c.r = rep(50, 99),
    #                   iterations = 100, burn.in = 10, thinning = 1, type.c = 2)
    # CuPloth(res, type.h = "segment",qn=.5, summary = T)
    # CuPloth(res, type.h = "line",qn=.5)




}
\references{
- Nieto-Barajas, L. E. (2003). Discrete time Markov gamma
processes and time dependent covariates in survival analysis. \emph{Bulletin
of the International Statistical Institute 54th Session}. Berlin. (CD-ROM).

-Nieto-Barajas, L. E., & Yin, G. (2008). Bayesian semiparametric cure rate
model with an unknown threshold. \emph{Scandinavian Journal of Statistics},
\strong{35(3)}, 540-556. https://doi.org/10.1111/j.1467-9469.2007.00589.x
}
\seealso{
\link{CuMRes},
}
