% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.select.R
\name{plot.select}
\alias{plot.select}
\title{Network Plot for \code{select} Objects}
\usage{
\method{plot}{select}(
  x,
  layout = "circle",
  pos_col = "#009E73",
  neg_col = "#D55E00",
  node_size = 10,
  edge_magnify = 1,
  groups = NULL,
  palette = "Set3",
  ...
)
}
\arguments{
\item{x}{An object of class \code{select}.}

\item{layout}{Character string. Which graph layout (defaults is \code{circle}) ?
See \link[sna]{gplot.layout}.}

\item{pos_col}{Character string. Color for the positive edges (defaults to \code{green}).}

\item{neg_col}{Character string.  Color for the negative edges (defaults to \code{green}).}

\item{node_size}{Numeric. The size of the nodes (defaults to \code{10}).}

\item{edge_magnify}{Numeric. A value that is multiplied by the edge weights. This increases (> 1) or
decrease (< 1) the line widths (defaults to 1).}

\item{groups}{A character string of length \emph{p} (the number of nodes in the model).
This indicates groups of nodes that should be the same color
(e.g., "clusters" or "communities").}

\item{palette}{A character string sepcifying the palette for the \code{groups}.
(default is \code{Set3}). See \href{http://www.cookbook-r.com/Graphs/Colors_(ggplot2)/}{palette options here}.}

\item{...}{Additional options passed to \link[GGally]{ggnet2}}
}
\value{
An object (or list of objects) of class \code{ggplot}
that can then be further customized.
}
\description{
Visualize the conditional (in)dependence structure.
}
\note{
A more extensive example of a custom plot is
provided \href{https://donaldrwilliams.github.io/BGGM/articles/netplot.html}{here}
}
\examples{
\donttest{
#########################
### example 1: one ggm ##
#########################

# data
Y <- bfi[,1:25]

# estimate
fit <- estimate(Y, iter = 250,
                progress = FALSE)

# "communities"
comm <- substring(colnames(Y), 1, 1)

# edge set
E <- select(fit)

# plot edge set
plt_E <- plot(E, edge_magnify = 5,
              palette = "Set1",
              groups = comm)


#############################
### example 2: ggm compare ##
#############################
# compare males vs. females

# data
Y <- bfi[,1:26]

Ym <- subset(Y, gender == 1,
             select = -gender)

Yf <- subset(Y, gender == 2,
              select = -gender)

# estimate
fit <- ggm_compare_estimate(Ym, Yf, iter = 250,
                            progress = FALSE)

# "communities"
comm <- substring(colnames(Ym), 1, 1)

# edge set
E <- select(fit)

# plot edge set
plt_E <- plot(E, edge_magnify = 5,
              palette = "Set1",
              groups = comm)


}

}
