% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.VAR_estimate.R
\name{select.var_estimate}
\alias{select.var_estimate}
\title{Graph Selection for \code{var.estimate} Object}
\usage{
\method{select}{var_estimate}(object, cred = 0.95, alternative = "two.sided", ...)
}
\arguments{
\item{object}{An object of class \code{VAR.estimate}.}

\item{cred}{Numeric. The credible interval width for selecting the graph
(defaults to 0.95; must be between 0 and 1).}

\item{alternative}{A character string specifying the alternative hypothesis. It
must be one of "two.sided" (default), "greater"  or "less".
See note for futher details.}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{select.var_estimate}, including

\itemize{

\item {pcor_adj} Adjacency matrix for the partial correlations.

\item {beta_adj} Adjacency matrix for the regression coefficients.

\item {pcor_weighted_adj} Weighted adjacency matrix for the partial correlations.

\item {beta_weighted_adj} Weighted adjacency matrix for the regression coefficients.

\item \code{pcor_mu} Partial correlation matrix (posterior mean).

\item \code{beta_mu} A matrix including the regression coefficients (posterior mean).

}
}
\description{
Graph Selection for \code{var.estimate} Object
}
\examples{
\donttest{
# data
Y <- subset(ifit, id == 1)[,-1]

# fit model with alias (var_estimate also works)
fit <- var_estimate(Y, progress = FALSE)

# select graphs
select(fit, cred = 0.95)

}
}
