% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FINAL_FUNCTIONS_regression_test.R
\name{regression_test_BFF}
\alias{regression_test_BFF}
\title{regression_test_BFF}
\usage{
regression_test_BFF(
  t_stat,
  n = NULL,
  k = NULL,
  alternative = "two.sided",
  omega = NULL,
  omega_sequence = if (is.null(omega)) seq(0.01, 1, by = 0.01),
  r = 1
)
}
\arguments{
\item{t_stat}{T statistic}

\item{n}{sample size (if one sample test)}

\item{k}{number of predictors}

\item{alternative}{is the alternative a one.sided or two.sided test? default is two.sided}

\item{omega}{standadized effect size. For the regression test, this is also known as Cohen's f^@ (can be a single entry or a vector of values)}

\item{omega_sequence}{sequence of standardized effect sizes. If no omega is provided, omega_sequence is set to be seq(0.01, 1, by = 0.01)}

\item{r}{variable controlling dispersion of non-local priors. Default is 1.}
}
\value{
Returns an S3 object of class `BFF` (see `BFF.object` for details).
}
\description{
regression_test_BFF constructs BFFs based on the t test. BFFs depend on hyperparameters r and tau^2 which determine the shape and scale of the prior distributions which define the alternative hypotheses.
By setting r > 1, we use higher-order moments for replicated studies. Fractional moments are set with r > 1 and r not an integer.
All results are on the log scale.
}
\examples{
regBFF = regression_test_BFF(t_stat = 1.5, n = 50, k = 3)
regBFF
plot(regBFF)

}
