% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBeIdSymbols.R
\name{getBeIdSymbols}
\alias{getBeIdSymbols}
\title{Get symbols of Biological Entity identifiers}
\usage{
getBeIdSymbols(ids, be, source, organism, limForCache = 4000, ...)
}
\arguments{
\item{ids}{list of identifiers}

\item{be}{one BE. \strong{Guessed if not provided}}

\item{source}{the BE ID database. \strong{Guessed if not provided}}

\item{organism}{organism name. \strong{Guessed if not provided}}

\item{limForCache}{if there are more ids than limForCache. Results are
collected for all IDs (beyond provided ids) and cached for futur queries.
If not, results are collected only for provided ids and not cached.}

\item{...}{params for the \link{getBeIdSymbolTable} function}
}
\value{
a data.frame with the
following fields:
\itemize{
\item \strong{id}: the from BE ID
\item \strong{symbol}: the BE symbol
\item \strong{canonical}: true if the symbol is canonical for the direct BE ID
\item \strong{direct}: false if the symbol is not directly associated to the BE ID
\item \strong{preferred}: true if the id is the preferred identifier for the BE
\item \strong{entity}: (optional) the technical ID of to BE
}
}
\description{
Get symbols of Biological Entity identifiers
}
\examples{
\dontrun{
getBeIdSymbols(
   ids=c("10", "100"),
   be="Gene",
   source="EntrezGene",
   organism="human"
)
}

}
\seealso{
\link{getBeIdSymbolTable}, \link{getBeIdNames}
}
