% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convBeIdLists.R
\name{convBeIdLists}
\alias{convBeIdLists}
\title{Converts lists of BE IDs}
\usage{
convBeIdLists(idList, entity = FALSE, ...)
}
\arguments{
\item{idList}{a list of IDs lists}

\item{entity}{if TRUE returns BE instead of BEID (default: FALSE).
BE CAREFUL, THIS INTERNAL ID IS NOT STABLE AND CANNOT BE USED AS A REFERENCE.
This internal identifier is useful to avoid biases related to identifier
redundancy. See <../doc/BED.html#3_managing_identifiers>}

\item{...}{params for the \link{convBeIds} function}
}
\value{
A list of \link{convBeIds} ouput ids.
Scope ("be", "source" "organism" and "entity" (see Arguments))
is provided as a named list
in the "scope" attributes: \code{attr(x, "scope")}
}
\description{
Converts lists of BE IDs
}
\examples{
\dontrun{
convBeIdLists(
   idList=list(a=c("10", "100"), b=c("1000")),
   from="Gene",
   from.source="EntrezGene",
   from.org="human",
   to.source="Ens_gene"
)
}

}
\seealso{
\link{convBeIds}, \link{convDfBeIds}
}
