## ------------------------------------------------------------------------------------------------|
#     Copyright (C) 2012 - 2018  Reza Mohammadi                                                    |
#                                                                                                  |
#     This file is part of BDgraph package.                                                        |
#                                                                                                  |
#     BDgraph is free software: you can redistribute it and/or modify it under                     |
#     the terms of the GNU General Public License as published by the Free                         |
#     Software Foundation; see <https://cran.r-project.org/web/licenses/GPL-3>.                    |
#                                                                                                  |
#     Maintainer: Reza Mohammadi <a.mohammadi@uva.nl>                                              |
## ------------------------------------------------------------------------------------------------|
#     Non-parametric transfer function for non-normal data                                         |
## ------------------------------------------------------------------------------------------------|

bdgraph.npn = function( data, npn = "shrinkage", npn.thresh = NULL )
{
    if( class( data ) == "sim" ) data <- data $ data
    
    if( !is.matrix( data ) & !is.data.frame( data ) ) stop( "Data must be a matrix or dataframe" )	
    if( is.data.frame( data ) ) data = data.matrix( data )
    if( any( is.na( data ) ) ) stop( "Data must contain no missing data" ) 
	
	n <- nrow( data )
	
  	# ------ shrinkage transfer -------------------------------------------------------------------|
	
	if( npn == "shrinkage" )
	{
		data = qnorm( apply( data, 2, rank ) / ( n + 1 ) )
		data = data / sd( data[ , 1 ] )
	}
	
	# ------ truncation transfer ------------------------------------------------------------------|
	
	if( npn == "truncation" )
	{
		if( is.null( npn.thresh ) ) npn.thresh = 0.25 * ( n ^ ( -0.25 ) ) * ( pi * log( n ) ) ^ ( -0.5 )
		
		data = qnorm( pmin( pmax( apply( data, 2, rank ) / n, npn.thresh ), 1 - npn.thresh ) )
    	data = data / sd( data[ , 1 ] )
	}

	# ------ skeptic transfer ---------------------------------------------------------------------|
	
	if( npn == "skeptic" ) data = 2 * sin( pi / 6 * cor( data, method = "spearman" ) )
	
	return( data )
}
