% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.batss.R
\name{plot.batss}
\alias{plot.batss}
\title{Plot function for 'BATSS' outputs}
\usage{
\method{plot}{batss}(
  x,
  type = "size",
  hypothesis = "H1",
  title = TRUE,
  legend = TRUE,
  col = c("#008B0040", "#8B3A3A40", "#8B897040", "#FF990075", "blue"),
  ...
)
}
\arguments{
\item{x}{An object of class 'batss' (i.e., output of the function \link{batss.glm}).}

\item{type}{A character string indicating the type of plot with options 'size' (default) to display the total and per group sample size observed in the Monte Carlo trials, and 'estimates' to display the Monte Carlo trial target estimates as a function of the sample size.}

\item{hypothesis}{A character string indicating which alternative hypothesis to use for analyses considering both "H0" and "H1", with options "H1" (default) and "H0".}

\item{title}{Either a \link[base]{logical} indicating if a title should be added or a string (of class \link[base]{character}) indicating the title to be added. If \code{title} equals \code{TRUE} (default), the title 'Under 'H1' or 'Under 'H0' (depending on the argument \code{hypothesis}) is added to the outer margin of the plot. No outer margin space is added if \code{title = FALSE}.}

\item{legend}{a \link[base]{logical} (with default set to \code{TRUE}) indicating if, when '\code{type = estimates}', a legend should be added at the bottom of the plot.}

\item{col}{a vector of length 5 specifiying the colour respectively assigned to i/ efficacy, ii/ futility, iii/ neither or iv/ both when color-coding trials when \code{type = "estimates"}. The 5th colour is used for lines. Default to c("#8B897040","#008B0040","#8B3A3A40","#FF990075","blue") where the 2 last digits of the long hexadecimal strings of colours 1 to 4 specify the level of transluency. Refer to the Section 'colour specification' in \link[graphics]{par} for details. If the length of \code{col} equals 1, the same colour is used for all cases. When \code{type = "size"}, the 3rd and 5th colours of the vector \code{col} are used to display boxplots and lines.}

\item{...}{Additional arguments affecting the plot produced, like ylim and ylab.}
}
\value{
Generates graphical displays of results for objects of class 'batss'.
}
\description{
Plot for objects of class 'batss'
}
\seealso{
\code{\link[=batss.glm]{batss.glm()}}, the function generating S3 objects of class 'batss'.
}
