% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.hotspots}
\alias{kernel.hotspots}
\title{Hotspots in hypervolumes.}
\usage{
kernel.hotspots(comm, prop = 0.5)
}
\arguments{
\item{comm}{A 'Hypervolume' or 'HypervolumesList' object, preferably built using function kernel.build.}

\item{prop}{Proportion of random points to be included.}
}
\value{
A 'Hypervolume' or 'HypervolumeList' with the hotspots of each site.
}
\description{
Identify hotspots in kernel density hypervolumes based on minimum volume needed to cover a given proportion of random points.
}
\details{
Estimates the hotspots of one or more communities using kernel density hypervolumes as in Carmona et al. (2021).
}
\examples{
\dontrun{
comm = rbind(c(1,3,0,5,3), c(3,2,5,0,0))
colnames(comm) = c("SpA", "SpB", "SpC", "SpD", "SpE")
rownames(comm) = c("Site 1", "Site 2")

trait = data.frame(body = c(1,2,3,4,4), beak = c(1,5,4,1,2))
rownames(trait) = colnames(comm)

hv = kernel.build(comm[1,], trait)
plot(hv)
kernel.alpha(hv)

hot = kernel.hotspots(hv, 0.5)
plot(hot)
kernel.alpha(hot)

hvlist = kernel.build(comm, trait)
hot = kernel.hotspots(hvlist, 0.1)
kernel.alpha(hot)
}
}
\references{
Carmona, C.P., et al. (2021) Erosion of global functional diversity across the tree of life. Science Advances, 7: eabf2675. DOI: 10.1126/sciadv.abf2675
}
