% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.bass}
\alias{plot.bass}
\title{BASS Plot Diagnostics}
\usage{
\method{plot}{bass}(x, quants = c(0.025, 0.975), ...)
}
\arguments{
\item{x}{a \code{bass} object.}

\item{quants}{quantiles for intervals, if desired.  NULL if not desired.}

\item{...}{graphical parameters.}
}
\description{
Generate diagnostic plots for BASS model fit.
}
\details{
The first two plots are trace plots for diagnosing convergence.  The third plot is posterior predicted vs observed, with intervals for predictions.  The fourth plot is a histogram of the residuals (of the posterior mean model), with a red curve showing the assumed Normal density (using posterior mean variance).  If \code{bass} was run with \code{save.yhat = FALSE}, the third and fourth plots are omitted.
}
\examples{
# See examples in bass documentation.

}
\seealso{
\link{bass}, \link{predict.bass}, \link{sobol}
}
