% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_priors.R
\name{Bernoulli}
\alias{Bernoulli}
\alias{bernoulli}
\title{Independent Bernoulli Prior Distribution for Models}
\usage{
Bernoulli(probs = 0.5)
}
\arguments{
\item{probs}{a scalar or vector of prior inclusion probabilities. If a
scalar, the values is replicated for all variables ans a 1 is added for the
intercept. BAS checks to see if the length is equal to the dimension of the
parameter vector for the full model and addas a 1 to include the intercept.}
}
\value{
returns an object of class "prior", with the family and
hyerparameters.
}
\description{
Creates an object representing the prior distribution on models for BAS.
}
\details{
The independent Bernoulli prior distribution is a commonly used prior in
BMA, with the Uniform distribution a special case with probs=.5.  If all
indicator variables have a independent Bernoulli distributions with common
probability probs, the distribution on model size binomial(p, probs)
distribution.
}
\examples{
Bernoulli(.9)
}
\seealso{
\code{\link{bas.lm}},
\code{\link{beta.binomial}},\code{\link{uniform} }

Other priors modelpriors: \code{\link{Bernoulli.heredity}},
  \code{\link{beta.binomial}},
  \code{\link{tr.beta.binomial}}, \code{\link{tr.poisson}},
  \code{\link{tr.power.prior}}, \code{\link{uniform}}
}
\author{
Merlise Clyde
}
\concept{priors modelpriors}
