% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtRates.R
\name{dtRates}
\alias{dtRates}
\title{Calculate macroevolutionary rate changes on a phylogeny from
    \code{BAMM} output}
\usage{
dtRates(ephy, tau, ism = NULL, tmat = FALSE)
}
\arguments{
\item{ephy}{An object of class \code{bammdata}.}

\item{tau}{A numeric that specifies the size (as a fraction of tree
height) of the segments that each branch will be discretized into.}

\item{ism}{An integer vector indexing which posterior samples to include
in the calculation.}

\item{tmat}{A logical. If \code{TRUE} the matrix of branch segments is
returned.}
}
\value{
A \code{bammdata} object with a new component named "dtrates", which
    is a list with two or three components:
    \itemize{
        \item tau: The parameter value of \code{tau} used in the
            calculation.
        \item rates: If \code{ephy$type = "trait"}: a numeric vector with
            the phenotypic rates of each segment on each branch. If
            \code{ephy$type = "diversification"}: a list with two
            components. The first component is a numeric vector of
            speciation rates. The second component is a numeric vector of
            extinction rates.
        \item tmat: A matrix of the starting and ending times of the
            segments on each branch. Only if \code{tmat = TRUE}.
}
}
\description{
\code{dtRates} calculates the mean of the marginal posterior
    density of the rate of speciation/extinction or trait evolution for
    small segments along each branch in a phylogeny.
}
\details{
\code{dtRates} bins the phylogeny into windows of time and
    calculates average rates of speciation/extinction or phenotypic
    evolution along each segment of a branch within a window. The width of
    each window is determined by \code{tau}. \code{tau} is a fraction of
    the root to tip distance so a value of \code{tau = 0.01} bins the
    phylogeny into 100 time windows of equal width.
}
\note{
If there are zero length branches in the input tree \code{NA}s will
    result.
}
\examples{
data(whales, events.whales)
ed <- getEventData(whales, events.whales, burnin=0.25, nsamples=500)

# use all posterior samples
ed <- dtRates(ed, tau=0.01)

# use specified range of posterior samples
ed <- dtRates(ed, tau=0.01, ism=50:150)
}
\references{
\url{http://bamm-project.org/}
}
\seealso{
\code{\link{plot.bammdata}}
}
\author{
Mike Grundler
}
\keyword{graphics}
