\name{cohorts}
\alias{cohorts}
\title{
Visualize macroevolutionary cohorts
}
\description{
Plots the matrix of pairwise correlations in rate regimes between all tips in a phylogeny
}
\usage{
cohorts(x, ephy, col, pal, lwd = 1, ofs = 0, use.plot.bammdata = FALSE, 
			useraster = FALSE, LARGE = 500,...)
}
\arguments{
  \item{x}{
a matrix of pairwise correlations generated by \code{getCohortMatrix}.
}
  \item{ephy}{
an object of class \code{bammdata}.
}
  \item{col}{
a vector of colors passed to the function \code{image}. These will be used
to color the values in \code{x}. See documentation for \code{image}.  	
}
  \item{pal}{
the palette to use if \code{use.plot.bammdata=TRUE}. See options documented in
the help file for \code{plot.bammdata}.  	
}
  \item{lwd}{
a numeric indicating the width of branches in the phylogeny.  	
}
  \item{ofs}{
a numeric controlling the offset of the phylogeny from the matrix plot. Appropriate
values will probably be in the interval [0,0.1].  	
}
  \item{use.plot.bammdata}{
logical. should a phylorate plot be generated?  	
}
  \item{useraster}{
a logical indicating whether the function \code{image} should plot the matrix 
as a raster.  	
}
  \item{LARGE}{
an integer. If trees have more tips than \code{LARGE}, \code{useraster} will be
coerced to \code{TRUE}.  	
}
\item{...}{
	further arguments passed to \code{plot.bammdata} if \code{use.plot.bammdata=TRUE}
}
}
\details{
The plotting function creates an image of the BAMM correlation matrix between tip
lineages of the phylogeny. Each correlation is the posterior frequency with which a pair of lineages occurs in the same macroevolutionary rate regime. Correlations are
mapped to a set of colors, with warmer colors corresponding to higher correlations than cooler colors. The set of colors is specified by the \code{col} argument and 
a legend is plotted to guide interpretation of the color-correlation map. Trees are
plotted on the margins of the matrix image. The correlation between any two tips can be inferred by finding their intersection within the matrix image. 

IMPORTANT: the legend DOES NOT apply to 
the phylorate plots shown in the margin if \code{use.plot.bammdata=TRUE}. 
}

\author{
Mike Grundler
}

\seealso{
\code{\link{plot.bammdata}}, \code{\link{getCohortMatrix}}, \code{\link{image}}
}
\examples{
library(BAMMtools)
data(whales, events.whales)
ed <- getEventData(whales, events.whales, 0.1)
x <- getCohortMatrix(ed)
cohorts(x, ed)
cohorts(x, ed, col=richColors(64))
cohorts(x, ed, ofs=0.05, col=richColors(64))
cohorts(x, ed, pal="temperature", col=richColors(64))
# gray scale
cohorts(x, ed, col=gray(seq(0.2,0.9,length.out=128)), use.plot.bammdata=FALSE)
}
