% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_model_plots.R
\name{contour_model}
\alias{contour_model}
\title{Contourplot for bivariate angular mixture model densities}
\usage{
contour_model(model = "vmsin", kappa1, kappa2, kappa3, mu1, mu2,
  pmix = rep(1/length(kappa1), length(kappa1)), xpoints = seq(0, 2 * pi,
  length.out = 100), ypoints = seq(0, 2 * pi, length.out = 100), levels,
  nlevels = 20, xlab = "x", ylab = "y", col = "black", lty = 1, main,
  ...)
}
\arguments{
\item{model}{bivariate angular model whose mixture is of interest. Must be one of
"vmsin", "vmcos" and "wnorm2".}

\item{kappa1, kappa2, kappa3, mu1, mu2, pmix}{model parameters and mixing
proportions. See the respective mixture model densities (\link{dvmsinmix}, \link{dvmcosmix},
\link{dwnorm2mix}) for more details.}

\item{xpoints}{Points on the first (x-) coordinate where the density is to be evaluated.
Default to seq(0, 2*pi, length.out=100).}

\item{ypoints}{Points on the first (x-) coordinate where the density is to be evaluated.
Default to seq(0, 2*pi, length.out=100).}

\item{levels}{numeric vector of levels at which to draw contour lines;
passed to the \link{contour} function in graphics.}

\item{nlevels}{number of contour levels desired \strong{if} levels is not supplied;
passed to the \link{contour} function in graphics.}

\item{xlab, ylab, col, lty, main}{graphical parameters passed to \link{contour}.}

\item{...}{additional model specific argment}
}
\description{
Contourplot for bivariate angular mixture model densities
}
