% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blob_client_funcs.R
\name{list_blobs}
\alias{list_blobs}
\alias{upload_blob}
\alias{download_blob}
\alias{delete_blob}
\title{Operations on a blob container}
\usage{
list_blobs(container, info = c("partial", "name", "all"),
  prefix = NULL)

upload_blob(container, src, dest, type = "BlockBlob", blocksize = 2^24,
  lease = NULL)

download_blob(container, src, dest, overwrite = FALSE, lease = NULL)

delete_blob(container, blob, confirm = TRUE)
}
\arguments{
\item{container}{A blob container object.}

\item{info}{For \code{list_blobs}, level of detail about each blob to return: a vector of names only; the name, size and last-modified date (default); or all information.}

\item{prefix}{For \code{list_blobs}, filters the result to return only blobs whose name begins with this prefix.}

\item{src, dest}{The source and destination filenames for uploading and downloading. Paths are allowed.}

\item{type}{When uploading, the type of blob to create. Currently only block blobs are supported.}

\item{blocksize}{The number of bytes to upload per HTTP(S) request.}

\item{lease}{The lease for a blob, if present.}

\item{overwrite}{When downloading, whether to overwrite an existing destination file.}

\item{blob}{A string naming a blob.}

\item{confirm}{Whether to ask for confirmation on deleting a blob.}
}
\value{
For \code{list_blobs}, details on the blobs in the container.
}
\description{
Upload, download, or delete a blob; list blobs in a container.
}
\examples{
\dontrun{

cont <- blob_container("https://mystorage.blob.core.windows.net/mycontainer", key="access_key")

list_blobs(cont)

upload_blob(cont, "~/bigfile.zip", dest="bigfile.zip")
download_blob(cont, "bigfile.zip", dest="~/bigfile_downloaded.zip")

delete_blob(cont, "bigfile.zip")

}
}
\seealso{
\link{blob_container}, \link{az_storage}
}
