% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kusto_token.R
\name{get_kusto_token}
\alias{get_kusto_token}
\alias{delete_kusto_token}
\alias{list_kusto_tokens}
\title{Manage AAD authentication tokens for Kusto clusters}
\usage{
get_kusto_token(
  server = NULL,
  clustername,
  location = NULL,
  tenant = NULL,
  app = .kusto_app_id,
  auth_type = NULL,
  ...
)

delete_kusto_token(
  server = NULL,
  clustername,
  location = NULL,
  tenant = NULL,
  app = .kusto_app_id,
  auth_type = NULL,
  ...,
  hash = NULL,
  confirm = TRUE
)

list_kusto_tokens()
}
\arguments{
\item{server}{The URI of your Kusto cluster. If not supplied, it is obtained from the \code{clustername} and \code{location} arguments.}

\item{clustername}{The cluster name.}

\item{location}{The cluster location. Leave this blank for a Microsoft-internal Kusto cluster like "help".}

\item{tenant}{Your Azure Active Directory (AAD) tenant. Can be a GUID, a name ("myaadtenant") or a fully qualified domain name ("myaadtenant.com").}

\item{app}{The ID of the Azure Active Directory app/service principal to authenticate with. Defaults to the ID of the KustoClient app.}

\item{auth_type}{The authentication method to use. Can be one of "authorization_code", "device_code", "client_credentials" or "resource_owner". The default is to pick one based on the other arguments.}

\item{...}{Other arguments to pass to \link[AzureAuth:get_azure_token]{AzureAuth::get_azure_token}.}

\item{hash}{For \code{delete_kusto_token}, the MD5 hash of the token. This is used to identify the token if provided.}

\item{confirm}{For \code{delete_kusto_token}, whether to ask for confirmation before deleting the token.}
}
\value{
\code{get_kusto_token} returns an object of class AzureAuth::AzureToken representing the authentication token, while \code{list_kusto_tokens} returns a list of such objects. \code{delete_azure_token} returns NULL on a successful delete.
}
\description{
Manage AAD authentication tokens for Kusto clusters
}
\details{
\code{get_kusto_token} returns an authentication token for the given cluster, caching its value on disk. \code{delete_kusto_token} deletes a cached token, and \code{list_kusto_tokens} lists all cached tokens.

By default, authentication tokens will be obtained using the main KustoClient Active Directory app. This app can be used to authenticate with any Kusto cluster (assuming, of course, you have the proper credentials).
}
\examples{
\dontrun{

get_kusto_token("myclust.australiaeast.kusto.windows.net")
get_kusto_token(clustername="myclust", location="australiaeast")

# authenticate using client_credentials method: see ?AzureAuth::get_azure_token
get_kusto_token("myclust.australiaeast.kusto.windows.net",
                tenant="mytenant", app="myapp", password="password")

}
}
\seealso{
\link{kusto_database_endpoint}, \link[AzureAuth:get_azure_token]{AzureAuth::get_azure_token}
}
