% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_kusto.R
\docType{class}
\name{az_kusto}
\alias{az_kusto}
\alias{create_database}
\alias{get_database}
\alias{delete_database}
\alias{list_databases}
\title{Kusto/Azure Data Explorer cluster resource class}
\format{An object of class \code{R6ClassGenerator} of length 25.}
\usage{
az_kusto
}
\description{
Class representing a Kusto cluster, exposing methods for working with it.
}
\section{Methods}{

The following methods are available, in addition to those provided by the \link[AzureRMR:az_resource]{AzureRMR::az_resource} class:
\itemize{
\item \code{new(...)}: Initialize a new storage object. See 'Initialization'.
\item \code{start()}: Start the cluster.
\item \code{stop()}: Stop the cluster.
\item \code{create_database(...)}: Create a new Kusto database. See \code{Databases} below.
\item \code{get_database(database))}: Get an existing database.
\item \code{delete_database(database, confirm=TRUE)}: Delete a database, by default asking for confirmation first.
\item \code{list_databases()}: List all databases in this cluster.
\item \code{get_default_tenant()}: Retrieve the default tenant to authenticate with this cluster.
\item \code{get_query_token(tenant, ...)}: Obtain an authentication token from Azure Active Directory for this cluster's query enpdoint. Accepts further arguments that will be passed to \link{get_kusto_token}.
\item \code{get_ingestion_token(tenant, ...)}: Obtain an authentication token for this cluster's ingestion endpoint. Accepts further arguments that will be passed to \link{get_kusto_token}.
}
}

\section{Initialization}{

Initializing a new object of this class can either retrieve an existing Kusto cluster, or create a new cluster on the host. Generally, the best way to initialize an object is via the \code{get_kusto_cluster} and \code{create_kusto_cluster} methods of the \link{az_resource_group} class, which handle the details automatically.
}

\section{Databases}{

A Kusto cluster can have several databases, which are represented in AzureKusto via \link{az_kusto_database} R6 objects. The \code{az_kusto} class provides the \code{create_database}, \code{get_database}, \code{delete_database} and \code{list_databases} methods for creating, deleting and retrieving databases. It's recommended to use these methods rather than calling \code{az_kusto_database$new()} directly.

\code{create_database} takes the following arguments. It returns an object of class \link{az_kusto_database}
\itemize{
\item \code{database}: The name of the database to create.
\item \code{retention_period}: The retention period of the database, after which data will be soft-deleted.
\item \code{cache_period}: The cache period of the database, the length of time for which queries will be cached.
}

\code{get_database} takes a single argument \code{database}, the name of the database to retrieve, and returns an object of class \code{az_kusto_database}. \code{delete_database} takes the name of the database to delete and returns NULL on a successful deletion. \code{list_databases} takes no arguments and returns a list of \code{az_kusto_database} objects, one for each database in the cluster.
}

\examples{
\dontrun{

# recommended way of retrieving a resource: via a resource group object
kus <- resgroup$get_kusto_cluster("mykusto")

# list databases
kust$list_databases()

# create a new database with a retention period of 6 months
kust$create_database("newdb", retention_period=180)

# get the default authentication tenant
kus$get_default_tenant()

# generate an authentication token
kust$get_aad_token()

}
}
\seealso{
\link{az_kusto_database}, \link{kusto_database_endpoint},
\link{create_kusto_cluster}, \link{get_kusto_cluster}, \link{delete_kusto_cluster},
\link{get_kusto_token}

\href{https://docs.microsoft.com/en-us/azure/data-explorer/}{Kusto/Azure Data Explorer documentation},
}
\keyword{datasets}
