% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch.R
\name{call_batch_endpoint}
\alias{call_batch_endpoint}
\title{Call the Graph API batch endpoint}
\usage{
call_batch_endpoint(token, requests = list(), depends_on = NULL,
  api_version = getOption("azure_graph_api_version"))
}
\arguments{
\item{token}{An Azure OAuth token, of class \link{AzureToken}.}

\item{requests}{A list of \link{graph_request} objects, representing individual requests to the Graph API.}

\item{depends_on}{An optional named vector, or TRUE. See below.}

\item{api_version}{The API version to use, which will form part of the URL sent to the host.}
}
\value{
A list containing the responses to each request. Each item has components \code{id} and \code{status} at a minimum. It may also contain \code{headers} and \code{body}, depending on the specifics of the request.
}
\description{
Call the Graph API batch endpoint
}
\details{
Use this function to combine multiple requests into a single HTTPS call. This can save significant network latency.

The \code{depends_on} argument specifies the dependencies that may exist between requests. The default is to treat the requests as independent, which allows them to be executed in parallel. If \code{depends_on} is TRUE, each request is specified as depending on the immediately preceding request. Otherwise, this should be a named vector or list that gives the dependency or dependencies for each request.

There are 2 restrictions on \code{depends_on}:
\itemize{
\item If one request has a dependency, then all requests must have dependencies specified
\item A request can only depend on previous requests in the list, not on later ones.
}

A request list that has dependencies will be executed serially.
}
\examples{
\dontrun{

req1 <- graph_request$new("me")

# a new email message in Outlook
req_create <- graph_request$new("me/messages",
    body=list(
        body=list(
            content="Hello from R",
            content_type="text"
        ),
        subject="Hello",
        toRecipients="bob@example.com"
    ),
    http_verb="POST"
)

# messages in drafts
req_get <- graph_request$new("me/mailFolders/drafts/messages")

# requests are dependent: 2nd list of drafts will include just-created message
call_batch_endpoint(token, list(req_get, req_create, req_get), depends_on=TRUE)

# alternate way: enumerate all requests
call_batch_endpoint(token, list(req_get, req_create, req_get), depends_on=c("2"=1, "3"=2))

}
}
\seealso{
\link{graph_request}, \link{call_graph_endpoint}

\href{https://docs.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://docs.microsoft.com/en-us/graph/json-batching}{Batch endpoint documentation}

\href{https://docs.oasis-open.org/odata/odata-json-format/v4.01/odata-json-format-v4.01.html#sec_BatchRequestsandResponses}{OData documentation on batch requests}
}
