% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_app.r
\docType{class}
\name{az_app}
\alias{az_app}
\title{Registered app in Azure Active Directory}
\format{An R6 object of class \code{az_app}, inheriting from \code{az_object}.}
\usage{
az_app
}
\description{
Base class representing an AAD app.
}
\section{Fields}{

\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{tenant}: The Azure Active Directory tenant for this app.
\item \code{type}: always "application" for an app object.
\item \code{properties}: The app properties.
\item \code{password}: The app password. Note that the Graph API does not return passwords, so this will be NULL for an app retrieved via \code{ms_graph$get_app()}.
}
}

\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new app object. Do not call this directly; see 'Initialization' below.
\item \code{delete(confirm=TRUE)}: Delete an app. By default, ask for confirmation first.
\item \code{update(...)}: Update the app data in Azure Active Directory. For what properties can be updated, consult the REST API documentation link below.
\item \code{do_operation(...)}: Carry out an arbitrary operation on the app.
\item \code{sync_fields()}: Synchronise the R object with the app data in Azure Active Directory.
\item \code{list_group_memberships()}: Return the IDs of all groups this app is a member of.
\item \code{list_object_memberships()}: Return the IDs of all groups, administrative units and directory roles this app is a member of.
\item \code{list_owners(type=c("user", "group", "application", "servicePrincipal"))}: Return a list of all owners of this app. Specify the \code{type} argument to filter the result for specific object type(s).
\item \code{create_service_principal(...)}: Create a service principal for this app, by default in the current tenant.
\item \code{get_service_principal()}: Get the service principal for this app.
\item \code{delete_service_principal(confirm=TRUE)}: Delete the service principal for this app. By default, ask for confirmation first.
\item \code{update_password(password=NULL, name="key1", password_duration=1)}: Updates the app password. Note that this will invalidate any existing password.
}
}

\section{Initialization}{

Creating new objects of this class should be done via the \code{create_app} and \code{get_app} methods of the \link{ms_graph} class. Calling the \code{new()} method for this class only constructs the R object; it does not call the Microsoft Graph API to create the actual app.

\href{https://docs.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://docs.microsoft.com/en-us/graph/api/overview?view=graph-rest-beta}{REST API reference}
}

\examples{
\dontrun{

gr <- get_graph_login()
app <- gr$create_app("MyNewApp")

# password reset
app$update_password()

# set a redirect URI
app$update(publicClient=list(redirectUris=I("http://localhost:1410")))

# add API permission (access Azure Storage as user)
app$update(requiredResourceAccess=list(
    list(
        resourceAppId="e406a681-f3d4-42a8-90b6-c2b029497af1",
        resourceAccess=list(
            list(
                id="03e0da56-190b-40ad-a80c-ea378c433f7f",
                type="Scope"
            )
        )
    )
))

# change the app name
app$update(displayName="MyRenamedApp")

}
}
\seealso{
\link{ms_graph}, \link{az_service_principal}, \link{az_user}, \link{az_group}, \link{az_object}
}
\keyword{datasets}
