% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelDerivative.R
\name{getOutputUrn}
\alias{getOutputUrn}
\title{Get the Output URN for a File.}
\usage{
getOutputUrn(urn, token)
}
\arguments{
\item{urn}{A string. Source URN (objectId) for the file. Note the URN must be
Base64 encoded. To encode the URN, see, for example, the
\code{jsonlite::base64_enc} function.}

\item{token}{A string. Token generated with \code{\link{getToken}} function
with \code{data:read} and \code{data:write} scopes.}
}
\value{
An object containing the \code{result}, \code{urn}, and additional
  activity information.
}
\description{
Get the output urn of a translated file using the Model Derivative API.
}
\examples{
\dontrun{
# Get the output urn for the "aerial.dwg" obj file
resp <- getOutputUrn(urn <- myUrn, token = Sys.getenv("token"))
resp
}
}
\seealso{
\url{https://developer.autodesk.com/en/docs/model-derivative/v2/overview/}
}
