% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R, R/tempo.R
\docType{methods}
\name{tempo}
\alias{tempo}
\alias{tempo-method}
\alias{plot,CumulativeEvents,missing-method}
\alias{tempo,EventsMCMC-method}
\title{Tempo Plot}
\usage{
tempo(object, ...)

\S4method{plot}{CumulativeEvents,missing}(
  x,
  calendar = getOption("ArchaeoPhases.calendar"),
  interval = c("credible", "gauss"),
  col.tempo = "#004488",
  col.interval = "grey",
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  panel.first = NULL,
  panel.last = NULL,
  ...
)

\S4method{tempo}{EventsMCMC}(
  object,
  level = 0.95,
  count = FALSE,
  credible = TRUE,
  gauss = TRUE,
  from = min(object),
  to = max(object),
  grid = getOption("ArchaeoPhases.grid")
)
}
\arguments{
\item{object}{An \code{\linkS4class{EventsMCMC}} object.}

\item{...}{Other \link[graphics:par]{graphical parameters} may also be passed as
arguments to this function.}

\item{x}{A \code{\linkS4class{CumulativeEvents}} object or an \code{\linkS4class{EventsMCMC}}
object.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[=calendar]{calendar()}}).}

\item{interval}{A \code{\link{character}} string specifying the confidence interval to
be drawn. It must be one of "\code{credible}" (credible interval) or "\code{gauss}"
(Gaussian approximation of the credible interval). Any unambiguous substring
can be given.}

\item{col.tempo, col.interval}{A specification for the plotting colors.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{panel.first}{An an \code{expression} to be evaluated after the plot axes are
set up but before any plotting takes place. This can be useful for drawing
background grids.}

\item{panel.last}{An \code{expression} to be evaluated after plotting has taken
place but before the axes, title and box are added.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}

\item{count}{A \code{\link{logical}} scalar: should the counting process be a number
or a probability (the default)?}

\item{credible}{A \code{\link{logical}} scalar: should the credible interval be
computed/displayed?}

\item{gauss}{A \code{\link{logical}} scalar: should the Gaussian approximation of the
credible interval be computed/displayed?}

\item{from}{A length-one \code{\link{numeric}} vector giving the earliest date to
estimate for (in years).}

\item{to}{A length-one \code{\link{numeric}} vector giving the latest date to estimate
for (in years).}

\item{grid}{A length-one \code{\link{numeric}} vector specifying the number of equally
spaced points of the temporal grid.}
}
\value{
\itemize{
\item \code{tempo()} returns an \code{\linkS4class{CumulativeEvents}} object.
\item \code{plot()} is called it for its side-effects: it results in a graphic being
displayed (invisibly returns \code{x}).
}
}
\description{
A statistical graphic designed for the archaeological study of rhythms of the
long term that embodies a theory of archaeological evidence for the
occurrence of events.
}
\details{
The tempo plot is one way to measure change over time: it estimates the
cumulative occurrence of archaeological events in a Bayesian calibration.
The tempo plot yields a graphic where the slope of the plot directly
reflects the pace of change: a period of rapid change yields a steep slope
and a period of slow change yields a gentle slope. When there is no change,
the plot is horizontal. When change is instantaneous, the plot is vertical.
}
\examples{
## Coerce to MCMC
eve <- as_events(mcmc_events, calendar = CE(), iteration = 1)
eve <- eve[1:10000, ]

## Tempo plot
tmp <- tempo(eve)
plot(tmp)
plot(tmp, interval = "credible", panel.first = grid())
plot(tmp, interval = "gauss", panel.first = grid())

## Activity plot
act <- activity(tmp)
plot(act, panel.first = grid())
}
\references{
Dye, T. S. (2016). Long-term rhythms in the development of Hawaiian social
stratification. \emph{Journal of Archaeological Science}, 71: 1-9.
\doi{10.1016/j.jas.2016.05.006}.
}
\seealso{
Other event tools: 
\code{\link{activity}()},
\code{\link{elapse}()},
\code{\link{occurrence}()}
}
\author{
A. Philippe, M.-A. Vibet, T. S. Dye, N. Frerebeau
}
\concept{event tools}
