% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{PhasesTransition}
\alias{PhasesTransition}
\title{Transition range between two successive phases (for phases in temporal order constraint)}
\usage{
PhasesTransition(Phase1Max_chain, Phase2Min_chain, level = 0.95)
}
\arguments{
  \item{Phase1Max_chain}{numeric vector containing the output of the MCMC algorithm for the maximum of the dates included in the oldest phase}
  \item{Phase2Min_chain}{numeric vector containing the output of the MCMC algorithm for the minimum of the dates included in the youngest phase}
  \item{level}{probability corresponding to the level of confidence}
}
\value{
Returns a vector of values containing the level of confidence and the endpoints of the transition interval between the successive phases. The result is given in calendar year (in format BC/AD).
}
\description{
Finds if it exists the shortest interval [TransitionRangeInf , TransitionRangeSup ] that satisfies : P(TransitionRangeInf < Phase1Max_chain < Phase2Min_chain < TransitionRangeSup  | M) = level
}
\references{
Anne Philippe, Marie-Anne Vibet. (2020). Analysis of Archaeological Phases using the CRAN Package 'ArchaeoPhases', <doi:10.18637/jss.v093.c01>. 
}
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  data(Phases); attach(Phases)
  PhasesTransition(Phase.1.beta, Phase.2.alpha, 0.95)
  PhasesTransition(Phase.1.beta, Phase.2.alpha, 0.50)
}
\keyword{ transition between two phases}
\keyword{ temporal order}
\keyword{ succession of phases }