AnimalHabitatNetwork
====================
Maintainer: Peng He (<phe@ab.mpg.de>)

This package is for generating and visualising networks for characterising the physical attributes and spatial organisations of habitat components (i.e. habitat physical configurations). The network generating algorithm first determines the `X` and `Y` coordinates of `N` nodes within a rectangle with a side length of `L` and an area of `A`. Then it computes the pair-wise Euclidean distance `Dij` between node `i` and `j`, and then a complete network with `1/Dij` as link weights is constructed. Then, the algorithm removes links from the complete network with the probability as shown in the function `ahn_prob` in this package. Such link removals can make the network disconnected whereas a connected network is wanted. In such cases, the algorithm rewires one network component to its spatially nearest neighbouring component and repeat doing this until the network becomes connected again. Finally, it generates an undirected network (weighted or unweighted, connected or disconnected, as users' choices).

Currently, the package consists of three functions:

1) `ahn_gen()`: generating or constructing networks
2) `ahn_prob()`: plotting the probability curves for removing links from the complete network
3) `ahn_plot()`: plotting networks generated by `ahn_gen()`


Installation
------------

Install `AnimalHabitatNetwork` from [CRAN](https://CRAN.R-project.org) with:

``` r
install.packages("AnimalHabitatNetwork")
```

Examples
-------

Below are some examples illustrating the uses of these functions:

``` r
library(AnimalHabitatNetwork)

# the use of the function ahn_gen()
ahn_gen(N = 30, L = 10, mu = .5, lamda = .75)
N <- 10
coord <- runif(N, 0, 5)
ql <- sample(LETTERS, N, replace = TRUE)
qn <- sample(1:20, N, replace = TRUE)
ahn_gen(N, L = 5, mu = 1, lamda = 5, Weighted = FALSE, X = coord, U = ql, V = qn)
ahn_gen(N, L = 5, mu = 1, lamda = 5, Weighted = TRUE, Connected = FALSE, Y = coord, U = ql, V = qn)

# the use of the function ahn_plot()
ahn_plot(ahn_gen(N = 30, L = 5, mu = .5, lamda = .75))

# the use of the function ahn_prob()
ahn_prob()
ahn_prob(Dij = seq(.05, 10, length.out = 30), mu = c(.1, 2, 5), lamda = c(.0001, .15, .35, 2, 30))
```

``` r
library(AnimalHabitatNetwork)

# generate networks with approximate structural properties

```
