% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pullGeno.R
\name{getGenMap}
\alias{getGenMap}
\title{Get genetic map}
\usage{
getGenMap(object = NULL, sex = "A")
}
\arguments{
\item{object}{where to retrieve the genetic map. 
Can be an object of \code{\link{SimParam}} or 
\code{\link{MapPop-class}}. If NULL, the function will 
look for a SimParam object called "SP" in your 
global environment.}

\item{sex}{determines which sex specific map 
is returned. Options are "A" for average map, "F" 
for female map, and "M" for male map. All options are 
equivalent if not using sex specific maps or using 
pulling from a MapPop.}
}
\value{
Returns a data.frame with:
\describe{
  \item{id}{Unique identifier for locus}
  \item{chr}{Chromosome containing the locus}
  \item{pos}{Genetic map position}
}
}
\description{
Retrieves the genetic map for all loci.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
getGenMap(founderPop)

}
