% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plot_SP_summary}
\alias{plot_SP_summary}
\title{A line plot summary of sum of pairs score between two multiple sequence alignments}
\usage{
plot_SP_summary(x, CS = TRUE, display = TRUE)
}
\arguments{
\item{x}{an object of type "pairwise alignment comparison" (typically the summary file generated by compare_alignments)}

\item{CS}{indicate columns with 100 percent identity using markers on the x-axis (default = TRUE)}

\item{display}{display this plot (default = TRUE)}
}
\description{
A line plot summary of sum of pairs score between two multiple sequence alignments
}
\note{
This function generates a plot that summarises the columnwise sums of pairs for the two multiple sequence alignments. For each column of the comparison alignment, it plots the proportion of conserved residue pairs as a proportion of the poassible residue pairs. The overall sum of pairs score, reverse sum of pairs score, and column score are also reported as percentages.
}
\examples{
data(reference_alignment)
data(comparison_alignment)
PAC <- compare_alignments(reference_alignment, comparison_alignment, SP=TRUE)
plot_SP_summary(PAC)

}

