% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_multiPlot.R
\name{pat_multiPlot}
\alias{pat_multiPlot}
\alias{pat_multiplot}
\title{Display multiple plots on one page}
\usage{
pat_multiPlot(
  pat = NULL,
  plottype = "all",
  sampleSize = 5000,
  columns = NULL,
  ylim = NULL,
  a_size = 1,
  a_shape = 15,
  a_color = rgb(0.9, 0.25, 0.2),
  b_size = 1,
  b_shape = 15,
  b_color = rgb(0.2, 0.25, 0.9),
  t_size = 1,
  t_shape = 15,
  t_color = "black",
  h_size = 1,
  h_shape = 15,
  h_color = "black",
  alpha = 0.5,
  timezone = NULL
)

pat_multiplot(
  pat = NULL,
  plottype = "all",
  sampleSize = 5000,
  columns = NULL,
  ylim = NULL,
  a_size = 1,
  a_shape = 15,
  a_color = rgb(0.9, 0.25, 0.2),
  b_size = 1,
  b_shape = 15,
  b_color = rgb(0.2, 0.25, 0.9),
  t_size = 1,
  t_shape = 15,
  t_color = "black",
  h_size = 1,
  h_shape = 15,
  h_color = "black",
  alpha = 0.5,
  timezone = NULL
)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}

\item{plottype}{Quick-reference plot types: "all", "aux", "pm25".}

\item{sampleSize}{Either an integer or fraction to determine sample size.}

\item{columns}{Number of columns in the plot layout. Use \code{NULL} for 
defaults.}

\item{ylim}{Vector of (lo,hi) y-axis limits.}

\item{a_size}{Size of pm25_A points.}

\item{a_shape}{Symbol to use for pm25_A points.}

\item{a_color}{Color of pm25_A points.}

\item{b_size}{Size of pm25_B points.}

\item{b_shape}{Symbol to use for pm25_B points.}

\item{b_color}{Color of pm25_B points.}

\item{t_size}{Size of temperature points.}

\item{t_shape}{Symbol to use for temperature points.}

\item{t_color}{Color of temperature points.}

\item{h_size}{Size of humidity points.}

\item{h_shape}{Symbol to use for humidity points.}

\item{h_color}{Color of humidity points.}

\item{alpha}{Opacity of points.}

\item{timezone}{Olson timezone used for the time axis. (Defaults to 
\code{pat} local time.)}
}
\value{
A ggplot object.
}
\description{
A plotting function that uses ggplot2 to display multiple 
ggplot objects in a single pane. Can either be passed individual ggplot 
objects OR a pat object and a plot type. 
Typical usage would be to supply \code{pat} and use the \code{plottype} 
argument to quickly display preformatted plots. 

Available \code{plottype} options include:

\itemize{
\item{\code{"all"} -- pm25_A, pm25_B, temperature, humidity}
\item{\code{"pm25_a"} -- PM2.5 from channel A only}
\item{\code{"pm25_b"} -- PM2.5 from channel B only}
\item{\code{"pm25"} -- PM2.5 from channels A and B in separate plots}
\item{\code{"pm25_over"} -- PM2.5 from channels A and B in the same plot}
\item{\code{"aux"} -- auxiliary data (temperature, humidity)}
}
}
\note{
Additional documentation of the multiplot algorithm is available at 
cookbook-r.com.
}
\examples{
\donttest{
library(AirSensor)

example_pat \%>\%
  pat_multiPlot(plottype = "pm25", alpha = 0.5)
}
}
