% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pas_addSpatialMetadata.R
\name{pas_addSpatialMetadata}
\alias{pas_addSpatialMetadata}
\title{Add Spatial Metadata to PurpleAIr Synoptic Data}
\usage{
pas_addSpatialMetadata(pas = NULL, countryCodes = NULL)
}
\arguments{
\item{pas}{PurpleAir Synoptic \emph{pas} object.}

\item{countryCodes}{(optional) ISO country codes used to subset the data.}
}
\value{
A pa_synoptic dataframe
}
\description{
Adds spatial metadata to a pa_synoptic object via the 
\code{MazamaSpatialUtils} Package using PurpleAir location coordinates to 
determine country, state, and timezone.
}
\examples{
\donttest{
library(AirSensor)

initializeMazamaSpatialUtils()

pas_enhanced <-
  example_pas_raw \%>\% 
  pas_addSpatialMetadata()
}
}
\seealso{
\link{pas_enhanceData}
}
