% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_onefactor.R
\name{grid.onefactor}
\alias{grid.onefactor}
\title{utils: group graphs of the output of simple experiments in dic, dbc or dql}
\usage{
grid.onefactor(output, model = "type1")
}
\arguments{
\item{output}{Vector with the outputs of the DIC, DBC or DQL functions}

\item{model}{Graph arrangement model, see in detail.}
}
\value{
returns grouped graphs
}
\description{
group graphs of the output of simple experiments into dic, dbc or dql. It is possible to group up to 6 graphs in different arrangements (see model argument)
}
\details{
- `type1`: Two graphs next to each other
- `type2`: Two graphs one below the other
- `type3`: Three graphs, two top and one centered below
- `type4`: Three graphs one below the other
- `type5`: Four graphs, two at the top and two at the bottom
- `type6`: Four graphs one below the other
- `type7`: Five graphs, two at the top, two in the middle and one centered at the bottom
- `type8`: Five graphs, three at the top, two centered at the bottom
- `type9`: Six graphs, three at the top, three centered at the bottom
- `type10`: Six graphs, two at the top, two in the middle and two at the bottom
}
\examples{
data("pomegranate")
attach(pomegranate)
a=DIC(trat, WL, geom = "point", ylab = "WL")
b=DIC(trat, SS, geom = "point", ylab="SS")
c=DIC(trat, AT, geom = "point", ylab = "AT")
grid.onefactor(c(a,b),model = "type1")
grid.onefactor(c(a,b),model = "type2")
grid.onefactor(c(a,b,c),model = "type3")
grid.onefactor(c(a,b,c),model = "type4")
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
