% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar_dunnett.R
\name{bar_dunnett}
\alias{bar_dunnett}
\title{Graph: Barplot for Dunnett test}
\usage{
bar_dunnett(
  output.dunnett,
  ylab = "Response",
  xlab = "",
  fill = c("#F8766D", "#00BFC4"),
  sup = NA,
  add.mean = TRUE,
  round = 2
)
}
\arguments{
\item{output.dunnett}{Numerical or complex vector with treatments}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{fill}{Fill column. Use vector with two elements c(control, different treatment)}

\item{sup}{Number of units above the standard deviation or average bar on the graph}

\item{add.mean}{Plot the average value on the graph (\emph{default} is TRUE)}

\item{round}{Number of cells}
}
\value{
Returns a column chart of Dunnett's test. The colors indicate difference from the control.
}
\description{
The function performs the construction of a column chart of Dunnett's test.
}
\examples{

#====================================================
# randomized block design in factorial double
#====================================================
library(AgroR)
data(cloro)
attach(cloro)
respAd=c(268, 322, 275, 350, 320)
a=FAT2DBC.ad(f1, f2, bloco, resp, respAd,
             ylab="Number of nodules",
             legend = "Stages",mcomp="sk")
data=rbind(data.frame(trat=paste(f1,f2,sep = ""),bloco=bloco,resp=resp),
           data.frame(trat=c("Test","Test","Test","Test","Test"),
                      bloco=unique(bloco),resp=respAd))
a= with(data,dunnett(trat = trat,
                  resp = resp,
                  control = "Test",
                  block=bloco,model = "DBC"))
 bar_dunnett(a)
}
