% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play_advance_stats.R
\name{play_advance_stats}
\alias{play_advance_stats}
\title{Play advanced statistics}
\usage{
play_advance_stats(df1)
}
\arguments{
\item{df1}{Should be a Data Frame that represents the play's statistics. The parameter has to be in the format provided by the play_data_adjustment() function.}
}
\value{
Data frame with the following advanced statistics calculated:
       \itemize{
                \item Points Per Possession (PPP)
                \item Possessions (POSS)
                \item Frequency (Freq)
                \item Efficiency Field Goals percentage (eFG\%)
                \item Free Throw Percentage (FT\%)
                \item Assists percentage (AST\%)
                \item Turnover percentage (TOV\%)
                \item And One percentage (AndOne\%)
                \item Score percentage (Score\%)
           }
}
\description{
This function allows the calculation of advanced play statistics.
}
\examples{

df1 <- data.frame("Name" = c("Sabonis ","Team"), "GP" = c(62,71),
"PTS" = c(387,0), "FG" = c(155,1), "FGA" = c(281,1),
"FGA Percentage" = c(0.552,1),"3P" = c(6,1),"3PA" = c(18,1),
"3P Percentage" = c(0.333,1),"2P" = c(149,0),"2PA" = c(263,0),
"2P Percentage" = c(0.567,0),"FT" = c(39,1),  "FTA" = c(53,1),
"FT Percentage" = c(0.736,1),  "ANDONE" = c(12,1), "AST" = c(0,1),
 "TOV" = c(27,1))

play_advance_stats(df1)


}
\author{
Fco Javier Cantero \email{fco.cantero@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
