% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_period.r
\name{report_period}
\alias{report_period}
\title{Generates reports based on input periods.}
\usage{
report_period(period, acti_data, remove_bad = TRUE, tz = "UTC", ...)
}
\arguments{
\item{period}{a dataframe containing participants and the start and end date/time periods.}

\item{acti_data}{a dataframe of the form 'acti_data'.}

\item{remove_bad}{a logical value used to indicate if 'bad' intervals or 'EXCLUDED' are removed. Set as TRUE.}

\item{tz}{is the time zone. Optional argument. tz = "UTC" by default.}

\item{...}{Optional parameters}
}
\value{
a dataframe
}
\description{
Generates reports based on input periods.
}
\details{
Periods partially scored as 'bad' or 'EXCLUDED' are due to off-wrist or other reasons.
In that case all summary estimates except ‘time in bed’ will be set to NA,
and the column ‘with_excluded_bad’ will show a TRUE. See examples in the Vignettes.
This can be avoided using remove_bad = FALSE.
Sleep efficiency will be zero when there is an attempt to sleep (no sleep achieved in the period) within a rest.
However, the sleep efficiency will be NA when there is not REST or SLEEP with in an interval of time.
}
\examples{
# Example 1
library("lubridate")
data("act")
par <- data.frame(subject_ID = 1,
summary_duration_h = 24,
summary_type = "sequential",
summary_start_datime = ymd_hms("2017-12-05 00:00:00 UTC"),
summary_end_datime = ymd_hms("2017-12-15 00:00:00 UTC"))
report_period(period = par , acti_data = act)
}
