% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{plot.accept_reject}
\alias{plot.accept_reject}
\title{Plot Accept-Reject}
\usage{
\method{plot}{accept_reject}(
  x,
  color_observed_density = "#BB9FC9",
  color_true_density = "#FE4F0E",
  color_bar = "#BB9FC9",
  color_observable_point = "#7BBDB3",
  color_real_point = "#FE4F0E",
  alpha = 0.3,
  hist = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \verb{accept reject}}

\item{color_observed_density}{Observed density color (continuous case).}

\item{color_true_density}{True histogram density color (continuous case)}

\item{color_bar}{Bar chart fill color (discrete case)}

\item{color_observable_point}{Color of generated points (discrete case)}

\item{color_real_point}{Color of real probability points (discrete case)}

\item{alpha}{Bar chart transparency (discrete case) and observed density
(continuous case)}

\item{hist}{If TRUE, a histogram will be plotted in the continuous case,
comparing the theoretical density with the observed one. If FALSE,
\code{\link[ggplot2:geom_density]{ggplot2::geom_density()}} will be used instead of the histogram.}

\item{...}{Additional arguments.}
}
\value{
An object of class \code{gg} and \code{ggplot} from the package \pkg{ggplot2}.
The function \code{\link[=plot.accept_reject]{plot.accept_reject()}} expects an object of class
\code{accept_reject} as an argument.
}
\description{
Inspects the probability function (discrete case) or probability density
(continuous case) by comparing the theoretical case with the observed one.
}
\details{
The function \code{\link[=plot.accept_reject]{plot.accept_reject()}} is responsible for plotting the
probability function (in the discrete case) or the probability density (in
the continuous case), comparing the theoretical case with the observed one.
It is useful, therefore, for inspecting the quality of the samples generated
by the acceptance-rejection method. The returned plot is an object of classes
\code{gg} and \code{ggplot}. Easily, you can further customize the plot.

The function \code{\link[=plot.accept_reject]{plot.accept_reject()}}, or simply \code{\link[=plot]{plot()}}, constructs the plot
for inspection and expects an object of class \code{accept_reject} as an argument.
}
\examples{
x <- accept_reject(
   n = 1000L,
   f = dbinom,
   continuous = FALSE,
   args_f = list(size = 5, prob = 0.5),
   xlim = c(0, 10)
)
plot(x)

y <- accept_reject(
  n = 500L,
  f = dnorm,
  continuous = TRUE,
  args_f = list(mean = 0, sd = 1),
  xlim = c(-4, 4)
)
plot(y)

}
\seealso{
\code{\link[=accept_reject]{accept_reject()}} and \code{\link[=print.accept_reject]{print.accept_reject()}}.
}
