% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_fill_layer.R
\name{scale_fill_academic_d}
\alias{scale_fill_academic_d}
\title{Scale Plot Fills With Academic Themes (Discrete)}
\usage{
scale_fill_academic_d(palette_name, ...)
}
\arguments{
\item{palette_name}{The name of a colour palette in \code{AcademicThemes}.}

\item{...}{Arguments passed to \code{ggplot2::discrete_scale()}.}
}
\value{
A layer that can be added to a ggplot2 object.
}
\description{
Scale Plot Fills With Academic Themes (Discrete)
}
\examples{
library(ggplot2)
ggplot(
  data.frame(
    x = LETTERS[1:5],
    y = 5:1
  ),
  aes(x = x, y = y, fill = x)
) +
  geom_col() +
  scale_fill_academic_d("cruk") +
  theme_classic() +
  labs(
    x = "X-Axis",
    y = "Y-Axis",
    fill = "Fill"
  )
}
