% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hotspot_df}
\alias{hotspot_df}
\title{hotspot_df}
\format{An object of class \code{data.frame} with 1024 rows and 6 columns.}
\source{
Yaari et al., Frontiers in Immunology, 2013
}
\usage{
hotspot_df
}
\description{
Hotspot mutations taken from Yaari et al., Frontiers in Immunology, 2013.
This contains transition probabilities for all 5mer combinations based
on high throughput sequencing data. The transition probabilities are for
the middle nucleotide in each 5mer set. This can be customized by changing the genes
and sequences. Custom mutation hotspots can be supplied
by modifying this dataframe. Repeating particular hotspot entries allows
for the hotspot to mutate more than one time per SHM event.
}
\details{
@format A data frame with 32 rows and 6 variables:
\describe{
  \item{pattern}{Character array where each entry corresponds to a 5 base motif. The
  mutation probabilities correspond to the middle nucleotide in each 5mer.}
  \item{toA}{The probability for the middle nucleotide in "pattern" to mutate to an adenine}
  \item{toC}{The probability for the middle nucleotide in "pattern" to mutate to an cytosine}
  \item{toG}{The probability for the middle nucleotide in "pattern" to mutate to an guanine}
  \item{toT}{The probability for the middle nucleotide in "pattern" to mutate to an thymine}
  \item{Source}{The origin of how this motif was discovered. Either Inferred or Experimental}
}
}
\keyword{datasets}

