/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.multilang;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShutdownReason;
import com.amazonaws.services.kinesis.clientlibrary.types.InitializationInput;
import com.amazonaws.services.kinesis.clientlibrary.types.ProcessRecordsInput;
import com.amazonaws.services.kinesis.multilang.MessageReader;
import com.amazonaws.services.kinesis.multilang.MessageWriter;
import com.amazonaws.services.kinesis.multilang.messages.CheckpointMessage;
import com.amazonaws.services.kinesis.multilang.messages.Message;
import com.amazonaws.services.kinesis.multilang.messages.StatusMessage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MultiLangProtocol {
    private static final Log log = LogFactory.getLog(MultiLangProtocol.class);
    private MessageReader messageReader;
    private MessageWriter messageWriter;
    private final InitializationInput initializationInput;

    MultiLangProtocol(MessageReader messageReader, MessageWriter messageWriter, InitializationInput initializationInput) {
        this.messageReader = messageReader;
        this.messageWriter = messageWriter;
        this.initializationInput = initializationInput;
    }

    boolean initialize() {
        Future<Boolean> writeFuture = this.messageWriter.writeInitializeMessage(this.initializationInput);
        return this.waitForStatusMessage("initialize", null, writeFuture);
    }

    boolean processRecords(ProcessRecordsInput processRecordsInput) {
        Future<Boolean> writeFuture = this.messageWriter.writeProcessRecordsMessage(processRecordsInput);
        return this.waitForStatusMessage("processRecords", processRecordsInput.getCheckpointer(), writeFuture);
    }

    boolean shutdown(IRecordProcessorCheckpointer checkpointer, ShutdownReason reason) {
        Future<Boolean> writeFuture = this.messageWriter.writeShutdownMessage(reason);
        return this.waitForStatusMessage("shutdown", checkpointer, writeFuture);
    }

    private boolean waitForStatusMessage(String action, IRecordProcessorCheckpointer checkpointer, Future<Boolean> writeFuture) {
        boolean statusWasCorrect = this.waitForStatusMessage(action, checkpointer);
        try {
            boolean writerIsStillOpen = writeFuture.get();
            return statusWasCorrect && writerIsStillOpen;
        }
        catch (InterruptedException e) {
            log.error((Object)String.format("Interrupted while writing %s message for shard %s", action, this.initializationInput.getShardId()));
            return false;
        }
        catch (ExecutionException e) {
            log.error((Object)String.format("Failed to write %s message for shard %s", action, this.initializationInput.getShardId()), (Throwable)e);
            return false;
        }
    }

    private boolean waitForStatusMessage(String action, IRecordProcessorCheckpointer checkpointer) {
        StatusMessage statusMessage = null;
        while (statusMessage == null) {
            Future<Message> future = this.messageReader.getNextMessageFromSTDOUT();
            try {
                Message message = future.get();
                if (message instanceof CheckpointMessage) {
                    boolean checkpointWriteSucceeded = this.checkpoint((CheckpointMessage)message, checkpointer).get();
                    if (checkpointWriteSucceeded) continue;
                    return false;
                }
                if (!(message instanceof StatusMessage)) continue;
                statusMessage = (StatusMessage)message;
            }
            catch (InterruptedException e) {
                log.error((Object)String.format("Interrupted while waiting for %s message for shard %s", action, this.initializationInput.getShardId()));
                return false;
            }
            catch (ExecutionException e) {
                log.error((Object)String.format("Failed to get status message for %s action for shard %s", action, this.initializationInput.getShardId()), (Throwable)e);
                return false;
            }
        }
        return this.validateStatusMessage(statusMessage, action);
    }

    private boolean validateStatusMessage(StatusMessage statusMessage, String action) {
        log.info((Object)("Received response " + statusMessage + " from subprocess while waiting for " + action + " while processing shard " + this.initializationInput.getShardId()));
        return statusMessage != null && statusMessage.getResponseFor() != null && statusMessage.getResponseFor().equals(action);
    }

    private Future<Boolean> checkpoint(CheckpointMessage checkpointMessage, IRecordProcessorCheckpointer checkpointer) {
        String sequenceNumber = checkpointMessage.getSequenceNumber();
        Long subSequenceNumber = checkpointMessage.getSubSequenceNumber();
        try {
            if (checkpointer != null) {
                log.debug((Object)this.logCheckpointMessage(sequenceNumber, subSequenceNumber));
                if (sequenceNumber != null) {
                    if (subSequenceNumber != null) {
                        checkpointer.checkpoint(sequenceNumber, subSequenceNumber);
                    } else {
                        checkpointer.checkpoint(sequenceNumber);
                    }
                } else {
                    checkpointer.checkpoint();
                }
                return this.messageWriter.writeCheckpointMessageWithError(sequenceNumber, subSequenceNumber, null);
            }
            String message = String.format("Was asked to checkpoint at %s but no checkpointer was provided for shard %s", sequenceNumber, this.initializationInput.getShardId());
            log.error((Object)message);
            return this.messageWriter.writeCheckpointMessageWithError(sequenceNumber, subSequenceNumber, new InvalidStateException(message));
        }
        catch (Throwable t) {
            return this.messageWriter.writeCheckpointMessageWithError(sequenceNumber, subSequenceNumber, t);
        }
    }

    private String logCheckpointMessage(String sequenceNumber, Long subSequenceNumber) {
        return String.format("Attempting to checkpoint shard %s @ sequence number %s, and sub sequence number %s", this.initializationInput.getShardId(), sequenceNumber, subSequenceNumber);
    }
}

