% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDEM.R
\name{getDEM}
\alias{getDEM}
\title{Downloads and imports Geoscience Australia 9s DEM.}
\usage{
getDEM(
  workingFolder = getwd(),
  urlDEM = getURLs()$DEM,
  DEMfilename = "dem-9s.asc",
  keepFiles = F
)
}
\arguments{
\item{workingFolder}{is the file path (as string) in which to download the zip file. The default is \code{getwd()}.}

\item{urlDEM}{URL to the folder containing the Geoscience Australia 9s DEM.
The default is taken from \code{getURLs()$DEM}.}

\item{DEMfilename}{is the file name for the DEM (as string). The default is \code{'dem-9s.asc'}.}

\item{keepFiles}{is a logical scalar to keep the downloaded zip file and extracted DEM ASCII file. The default is \code{FALSE}.}
}
\value{
A RasterLayer DEM for Asutralia.
}
\description{
\code{getDEM} get Australian 9s DEM.
}
\details{
getDEM downloads the Geoscience Australia 9 second DEM and then imports the grid.


The DEM is required for the calculation of evaportranspiration within \code{extractCatchmentData}. For details of the DEM see
\url{https://www.data.gov.au/dataset/geodata-9-second-dem-and-d8-digital-elevation-model-version-3-and-flow-direction-grid-2008}

For an example of how to download the DEM see the vignette "Extract daily area weighted potential evapotranspiration (PET) and precipitation".
}
\seealso{
\code{\link{extractCatchmentData}} for extracting catchment daily average and variance data.
}
