% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_metadata.R
\name{clean_metadata}
\alias{clean_metadata}
\title{Extract and clean ARU metadata from file names}
\usage{
clean_metadata(
  project_dir = NULL,
  project_files = NULL,
  file_type = "wav",
  subset = NULL,
  subset_type = "keep",
  pattern_site_id = create_pattern_site_id(),
  pattern_aru_id = create_pattern_aru_id(),
  pattern_date = create_pattern_date(),
  pattern_time = create_pattern_time(),
  pattern_dt_sep = create_pattern_dt_sep(),
  pattern_tz_offset = create_pattern_tz_offset(),
  order_date = "ymd",
  quiet = FALSE
)
}
\arguments{
\item{project_dir}{Character. Directory where project files are stored. File
paths will be used to extract information and must actually exist.}

\item{project_files}{Character. Vector of project file paths. These paths can
be absolute or relative to the working directory, and don't actually need
to point to existing files unless you plan to use \code{clean_gps()} or other
sampling steps down the line. Must be provided if \code{project_dir} is \code{NULL}.}

\item{file_type}{Character. Type of file (extension) to summarize. Default
wav.}

\item{subset}{Character. Text pattern to mark a subset of files/directories
to either \code{"keep"} or \code{"omit"} (see \code{subset_type})}

\item{subset_type}{Character. Either \code{keep} (default) or \code{omit}
files/directories which match the pattern in \code{subset}.}

\item{pattern_site_id}{Character. Regular expression to extract site ids. See
\code{create_pattern_site_id()}. Can be a vector of multiple patterns to match.}

\item{pattern_aru_id}{Character. Regular expression to extract ARU ids. See
\code{create_pattern_aru_id()}. Can be a vector of multiple patterns to match.}

\item{pattern_date}{Character. Regular expression to extract dates. See
\code{create_pattern_date()}. Can be a vector of multiple patterns to match.}

\item{pattern_time}{Character. Regular expression to extract times. See
\code{create_pattern_time()}. Can be a vector of multiple patterns to match.}

\item{pattern_dt_sep}{Character. Regular expression to mark separators
between dates and times. See \code{create_pattern_dt_sep()}.}

\item{pattern_tz_offset}{Character. Regular expression to extract time zone
offsets from file names. See. \code{create_pattern_tz_offset()}.}

\item{order_date}{Character. Order that the date appears in. "ymd"
(default), "mdy", or "dmy". Can be a vector of multiple patterns to match.}

\item{quiet}{Logical. Whether to suppress progress messages and other
non-essential updates.}
}
\value{
Data frame with extracted metadata
}
\description{
Using regular expressions, metadata is extracted from file names and
directory structure, checked and cleaned.
}
\details{
Note that times are extracted by first combining the date, date/time
separator and the time patterns. This means that if there is a problem with
this combination, dates might be extracted but date/times will not. This
mismatch can be used to determine which part of a pattern needs to be
tweaked.

See \code{vignette("customizing", package = "ARUtools")} for details on
customizing \code{clean_metadata()} for your project.
}
\examples{
clean_metadata(project_files = example_files)
clean_metadata(project_files = example_files, subset = "P02")

}
