% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_apti.R
\name{comp_apti}
\alias{comp_apti}
\title{Air Pollution Tolerance Index Calculator}
\usage{
comp_apti(A, TC, P, R)
}
\arguments{
\item{A}{Numeric vector of Ascorbic acid content, unit is mg per g dry weight}

\item{TC}{Numeric vector of Total chlorophyll content, unit is mg per g dry weight}

\item{P}{Numeric vector of Leaf extract pH.}

\item{R}{Numeric vector of Relative water content, in percentage}
}
\value{
A data frame containing APTI values and tolerance category:
\describe{
  \item{APTI}{Calculated index value.}
  \item{Category}{Plant tolerance class: \strong{Sensitive} (<12),
  \strong{Intermediate} (12–20), or \strong{Tolerant} (>20).}
}
}
\description{
This function calculates the Air Pollution Tolerance Index (APTI) using plant biochemical parameters: ascorbic acid (A), total chlorophyll (T),leaf extract pH (P), and relative water content (R) and classifies plants into tolerance categories based on biochemical parameters.APTI helps assess plant tolerance to air pollution.
}
\details{
This function returns original parameters, computed APTI values, and  tolerance categories: "Sensitive", "Intermediate", or "Tolerant".
}
\examples{
A <- c(4.91, 5.00, 4.90)
TC <- c(9.987, 8.881, 8.202)
P <- c(3.927, 3.872, 4.168)
R <- c(46.71, 55.11, 52.01)
comp_apti(A, TC, P, R)
}
\references{
1. Singh, S.K. and Rao, D.N. (1983) Evaluation of Plants for Their Tolerance to Air Pollution. Symposium on Air Pollution Control, 1983, 218-224.

2. Thakar, B. K., & Mishra, P. C. (2010). Dust collection potential and air pollution tolerance index of tree vegetation around Vedanta Aluminium Limited, Jharsuguda. The Bioscan, 3, 603-612.

3. Sahu, C., Basti, S., & Sahu, S. K. (2020). Air pollution tolerance index (APTI) and expected performance index (EPI) of trees in Sambalpur town of India. SN Applied Sciences, 2(8), 1327.
}
