% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_names.R
\name{strip_names_extra}
\alias{strip_names_extra}
\title{Strip taxon names, extra}
\usage{
strip_names_extra(taxon_names)
}
\arguments{
\item{taxon_names}{A character vector of taxonomic names to be stripped.}
}
\value{
A character vector of stripped taxonomic names,
with \code{sp.} and hybrid symbols removed.
}
\description{
Strip taxonomic names of \code{sp.} and hybrid symbols. This function assumes
that a character function has already been run through \code{strip_names}.
}
\details{
Given a vector of taxonomic names, this function removes additional filler
words (" x " for hybrid taxa, "sp.") not removed by the function
\code{strip_names}
}
\examples{
strip_names_extra(c("Abies lasiocarpa subsp. lasiocarpa",
              "Quercus kelloggii",
              "Pinus contorta var. latifolia",
              "Acacia sp.",
              "Lepidium sp. Tanguin Hill (K.R.Newbey 10501)"))

}
