% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.deletionsPlot.R
\name{stat.deletionsPlot}
\alias{stat.deletionsPlot}
\title{Plot for network deletion simulations}
\usage{
stat.deletionsPlot(ant, col.target = NULL, col.random = NULL)
}
\arguments{
\item{ant}{an ant object returned by function sta.deletion}

\item{col.target}{a character indicating the color of the target deletions}

\item{col.random}{a character indicating the color of the random deletions}
}
\value{
a plot.
}
\description{
Plot mean and stard deviation of the deletion simulation in the form of dual line plots.
}
\details{
knockout analysis allows the study of resilience properties of networks when specific nodes are removed. It is usually compared with random deletions.
}
\examples{
M=matrix(sample(c(1:20),100,TRUE),ncol=10,nrow=10)
diag(M)=0
attr=sample(c('a','b'),10,TRUE)
target='a' #categorical target node attributes
t=stat.deletions(M,attr = attr,target = target,nsim = 2,ndel=4)
stat.deletionsPlot(t)
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
