% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.reach.R
\name{met.reach}
\alias{met.reach}
\title{Reach centrality}
\usage{
met.reach(M, df = NULL, dfid = NULL)
}
\arguments{
\item{M}{a square adjacency matrix, or a list of square adjacency matrices, or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{df}{a data frame of same length as the input matrix or a list of data frames if argument \emph{M} is a list of matrices or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{dfid}{an integer or a string indicating the column with individual ids in argument \emph{df}.}
}
\value{
\itemize{
\item An integer vector of nodes \emph{reach centrality} if argument \emph{df} is \emph{NULL}.
\item A list of integer vectors of nodes \emph{reach centrality} if argument \emph{M} is a list of matrices and if argument \emph{df} is \emph{NULL}.
\item A list of arguments df with a new column for nodes \emph{reach centrality} titled 'reach centrality', if argument \emph{df} is not \emph{NULL}.
\item A list of arguments df with a new column for nodes \emph{reach centrality} if 1) argument \emph{df} is not \emph{NULL}, 2) argument \emph{M} is an output from ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk} for multiple matrices permutations, and 3) argument \emph{df} is a list of data frames of same length as argument \emph{M}. The name of the column of each element of the list is adapted according to argument value \emph{binary}.
}
}
\description{
Calculates the weighted node metric 'reach centrality' for all vertices.
}
\details{
Reach is the sum of the product of ego's and alters' strengths and alters' degrees.
}
\examples{
met.reach(sim.m)
head(sim.df)
met.reach(sim.m,df=sim.df)
}
\references{
Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
