% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oddsratio.2x2diff.R
\name{oddsratio.2x2diff}
\alias{oddsratio.2x2diff}
\title{Perform test for difference in odds ratios}
\usage{
oddsratio.2x2diff(
  x,
  y,
  z,
  alternative = c("two.sided", "less", "greater"),
  CI.width = 0.95,
  max.exact.perms = 1e+06,
  nsims.mc = 1e+05,
  seed = NULL,
  do.exact = TRUE,
  do.asymp = FALSE,
  do.mc = FALSE,
  do.CI = TRUE
)
}
\arguments{
\item{x}{Binary factor of same length as y, z}

\item{y}{Binary factor of same length as x, z}

\item{z}{Binary factor of same length as x, y}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{CI.width}{Confidence interval width (defaults to \code{0.95})}

\item{max.exact.perms}{Maximum number of permutations allowed for exact calculations (defaults to \code{1000000})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{100000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.mc}{Boolean indicating whether or not to perform Monte Carlo calculations (defaults to \code{FALSE})}

\item{do.CI}{Boolean indicating whether or not to perform confidence interval calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{oddsratio.2x2diff()} performs the test for difference in odds ratios and is used in chapter 13 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 13.2 from "Applied Nonparametric Statistical Methods" (5th edition)
oddsratio.2x2diff(ch13$physical.activity, ch13$tv.viewing, ch13$gender,
  do.exact = FALSE, do.asymp = TRUE)
oddsratio.2x2diff(ch13$physical.activity, ch13$tv.viewing, ch13$gender,
  do.exact = FALSE, do.mc = TRUE, seed = 1, nsims = 10000)

}
