% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peto.wilcoxon.R
\name{peto.wilcoxon}
\alias{peto.wilcoxon}
\title{Perform Peto-Wilcoxon test}
\usage{
peto.wilcoxon(
  x,
  y,
  x.c,
  y.c,
  alternative = c("two.sided", "less", "greater"),
  max.exact.perms = 1e+05,
  nsims.mc = 10000,
  seed = NULL
)
}
\arguments{
\item{x}{Numeric vector of same length as y, x.c, y.c}

\item{y}{Numeric vector of same length as x, x.c, y.c}

\item{x.c}{Binary vector of same length as x, y, x.c}

\item{y.c}{Binary vector of same length as x, y, y.c}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{max.exact.perms}{Maximum number of permutations allowed for exact calculations (defaults to \code{100000})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{10000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{peto.wilcoxon()} performs the Peto-Wilcoxon test and is used in chapter 9 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 9.4 from "Applied Nonparametric Statistical Methods" (5th edition)
peto.wilcoxon(ch9$sampleI.survtime, ch9$sampleII.survtime,
  ch9$sampleI.censor, ch9$sampleII.censor, alternative = "less")

}
