% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rng.test.R
\name{rng.test}
\alias{rng.test}
\title{Perform Range test}
\usage{
rng.test(x, alternative = c("two.sided"), minx = 0, maxx = 360)
}
\arguments{
\item{x}{Numeric vector}

\item{alternative}{Type of alternative hypothesis (defaults to \code{c("two.sided")})}

\item{minx}{Minimum value for x (defaults to \code{0})}

\item{maxx}{Maximum value for x (defaults to \code{360})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{rng.test()} performs the Range test and is used in chapter 4 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 4.17 from "Applied Nonparametric Statistical Methods" (5th edition)
rng.test(ch4$dates.as.degrees)

# Exercise 4.13 from "Applied Nonparametric Statistical Methods" (5th edition)
rng.test(ch4$accident.bearings)

}
