% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_isolates_unclean}
\alias{example_isolates_unclean}
\title{Data Set with Unclean Data}
\format{
A \link[tibble:tibble]{tibble} with 3 000 observations and 8 variables:
\itemize{
\item \code{patient_id}\cr ID of the patient
\item \code{date}\cr date of receipt at the laboratory
\item \code{hospital}\cr ID of the hospital, from A to C
\item \code{bacteria}\cr info about microorganism that can be transformed with \code{\link[=as.mo]{as.mo()}}, see also \link{microorganisms}
\item \code{AMX:GEN}\cr 4 different antibiotics that have to be transformed with \code{\link[=as.sir]{as.sir()}}
}
}
\usage{
example_isolates_unclean
}
\description{
A data set containing 3 000 microbial isolates that are not cleaned up and consequently not ready for AMR data analysis. This data set can be used for practice.
}
\details{
Like all data sets in this package, this data set is publicly available for download in the following formats: R, MS Excel, Apache Feather, Apache Parquet, SPSS, SAS, and Stata. Please visit \href{https://msberends.github.io/AMR/articles/datasets.html}{our website for the download links}. The actual files are of course available on \href{https://github.com/msberends/AMR/tree/main/data-raw}{our GitHub repository}.
}
\examples{
example_isolates_unclean
}
\keyword{datasets}
